//
//  ViewController.swift
//  Integration
//
//  Created by NurWork on 23/11/15.
//  Copyright © 2015 RWTH Aachen Univesity. All rights reserved.
//

import UIKit
import Social



class ViewController: UIViewController, UIImagePickerControllerDelegate, UINavigationControllerDelegate {

    @IBOutlet weak var imageView:UIImageView!
    @IBOutlet weak var textView:UITextField!
    
    
    var documentController:UIDocumentInteractionController!
    var webPath:String?
 
    override func viewDidLoad() {
        super.viewDidLoad()
        
        documentController = UIDocumentInteractionController()
        
    }

    
    @IBAction func openIn(sender: AnyObject)
    {
        let filePath = NSBundle.mainBundle().pathForResource("File1", ofType: "txt", inDirectory: "My files")!

        documentController.URL = NSURL(fileURLWithPath: filePath)
        documentController.presentOptionsMenuFromRect(self.view.frame, inView: self.view, animated: true)
    }
    
    @IBAction func share(sender: AnyObject)
    {
        let filePath = NSBundle.mainBundle().pathForResource("Image1", ofType: "jpg", inDirectory: "My Images/Fave")!
        if let photo = UIImage(contentsOfFile: filePath)
        {
            let activityController = UIActivityViewController(activityItems: [photo], applicationActivities: [])
            activityController.excludedActivityTypes = [UIActivityTypePrint]
            presentViewController(activityController, animated: true, completion: nil)
        }
    }
    
    @IBAction func shortenURL(sender:AnyObject)
    {
        let activity = ShortenURL()

        let activityController = UIActivityViewController(activityItems: ["http://hci.rwth-aachen.de/iphone"], applicationActivities: [activity])
        self.presentViewController(activityController, animated: true, completion: nil)
    }
    
    @IBAction func takePhoto()
    {
        let picker = UIImagePickerController()
        picker.allowsEditing = true
        picker.delegate = self
        
        if UIImagePickerController.isSourceTypeAvailable(.Camera)
        {
            picker.sourceType = .Camera
            picker.cameraCaptureMode = .Photo
        }
        presentViewController(picker, animated: true, completion: nil)

        
    }
    
    @IBAction func sharePhoto()
    {
        let socialController = SLComposeViewController(forServiceType: SLServiceTypeFacebook)
        socialController.setInitialText("Check out this picture!")
        socialController.addImage(imageView.image)
        socialController.addURL(NSURL(string: "http://hci.rwth-aachen.de/iphone"))
        presentViewController(socialController, animated: true, completion: nil)

    }

    
    //MARK: ImagePicker delegates
    
    func imagePickerControllerDidCancel(picker: UIImagePickerController) {
        dismissViewControllerAnimated(true, completion: nil)
    }
    
    func imagePickerController(picker: UIImagePickerController, didFinishPickingMediaWithInfo info: [String : AnyObject]) {
        
        if let editedImage = info["UIImagePickerControllerEditedImage"] as? UIImage {
            imageView.image = editedImage
        } else if let originalImage = info["UIImagePickerControllerOriginalImage"] as? UIImage {
            imageView.image = originalImage
        } else {
            return
        }
        
        let imageName = storeImage(imageView.image!) //just for demo
        
        let path = NSSearchPathForDirectoriesInDomains(.DocumentDirectory, .UserDomainMask, true)[0].stringByAppendingString(imageName)
        
        imageView.image = UIImage(contentsOfFile: path)
        
        dismissViewControllerAnimated(true, completion: nil)
    }
    
    func storeImage(image:UIImage) -> String
    {
        //create a path for image in use documnets
        let name = NSUUID().UUIDString //Universally Unique Identifier
        let documentsDirectory = NSSearchPathForDirectoriesInDomains(.DocumentDirectory, .UserDomainMask, true)[0]
        
        let path = documentsDirectory.stringByAppendingString(name)
        
        // a quality value between 0 and 100
        if let jpegData = UIImageJPEGRepresentation(image, 70)
        {
            jpegData.writeToFile(path, atomically: true)
        }
        
        return name
    }
    
    
    //MARK: Navigation

    override func prepareForSegue(segue: UIStoryboardSegue, sender: AnyObject?) {
        if segue.identifier == "ShowWeb" {
            let webViewController = segue.destinationViewController as! WebViewController
            if let path = textView.text
            {
                webViewController.path = path
            }
        }
    }

}

